#ifndef __LINUX_DS2782_BATTERY_H
#define __LINUX_DS2782_BATTERY_H

struct ds278x_platform_data {
	int rsns;
};

u8 get_ds2786_capacity(void);
u16 get_ds2786_voltage(void);
int get_ds2786_current(void);

///////////////////////////////////
// Gas gauge resigers
///////////////////////////////////

// Status/Config register
#define DS2786B_STATUSCONF  0x01

// Relative cell capacity
#define DS2786B_RELCAP      0x02

// Aux input 0
#define DS2786B_AIN0_MSB       0x08
#define DS2786B_AIN0_LSB       0x09

// Aux input 1
#define DS2786B_AIN1_MSB       0x0A
#define DS2786B_AIN1_LSB       0x0B

// Temperature register (same as that of Aux input 1)
#define DS2786B_TEMP_MSB       0x0A
#define DS2786B_TEMP_LSB       0x0B

// Voltage registers. Resolution 1.22mV
// MSBit (bit 15) is Sign bit, Bit 14 thru Bit 3 valid value, Bit 2 thru 0, reserved.
#define DS2786B_VOLT_MSB       0x0C
#define DS2786B_VOLT_LSB       0x0D

// Current register
#define DS2786B_CURR_MSB       0x0E
#define DS2786B_CURR_LSB       0x0F

// Initial voltage register
#define DS2786B_INIVOLT_MSB    0x14
#define DS2786B_INIVOLT_LSB    0x15

// Last OCV
#define DS2786B_LASTOCV     0x16

// Learned capacity scaling factor
#define DS2786B_LRNCAPSCALE 0x17

// Command register
#define DS2786B_COMMAND     0xFE

//-----------------------------------------
// Registers at location 0x60 through 0x7F
// They are in EEPROM and SHADOW RAM
//-----------------------------------------
// Current Offset Bias (COBR)
#define DS2786B_COBR        0x60

// OCV model capacity registers (CAP0 and CAP8 can't be changed)
#define DS2786B_CAP1        0x61
#define DS2786B_CAP2        0x62
#define DS2786B_CAP3        0x63
#define DS2786B_CAP4        0x64
#define DS2786B_CAP5        0x65
#define DS2786B_CAP6        0x66
#define DS2786B_CAP7        0x67

// Voltage break point registers
#define DS2786B_VOLTBR0H    0x68
#define DS2786B_VOLTBR0L    0x69
#define DS2786B_VOLTBR1H    0x6A
#define DS2786B_VOLTBR1L    0x6B

#define DS2786B_VOLTBR2H    0x6C
#define DS2786B_VOLTBR2L    0x6D

#define DS2786B_VOLTBR3H    0x6E
#define DS2786B_VOLTBR3L    0x6F

#define DS2786B_VOLTBR4H    0x70
#define DS2786B_VOLTBR4L    0x71

#define DS2786B_VOLTBR5H    0x72
#define DS2786B_VOLTBR5L    0x73

#define DS2786B_VOLTBR6H    0x74
#define DS2786B_VOLTBR6L    0x75

#define DS2786B_VOLTBR7H    0x76
#define DS2786B_VOLTBR7L    0x77

#define DS2786B_VOLTBR8H    0x78
#define DS2786B_VOLTBR8L    0x79

// Initial capacity scaling factor
#define DS2786B_INCAPSCALE  0x7A

// OCV threshold
#define DS2786B_OCVTHR      0x7B

// OCV DVDT threshold
#define DS2786B_OCVDVDTTHR  0x7C

// I2C Address configuration
#define DS2786B_I2CADDRCONF 0x7D

// Learn delta percent threshold (Recommended setting 50%)
#define DS2786B_LRNTHR      0x7E

// User EEPROM
#define DS2786B_USEREEP     0x7F


//------------------------------------------------------------------------------
// Bits of some of the registers
//------------------------------------------------------------------------------
// Command register DS2786B_COMMAND
#define COMMAND_BIT_COPY        (0x01)
#define COMMAND_BIT_RCALL       (0x02)
#define COMMAND_BIT_SOCV        (0x04)
#define COMMAND_BIT_POCV        (0x08)
#define COMMAND_BIT_POR         (0x80)

// Status/Configuration register DS2786B_STATUSCONF
#define STATUS_CONFIG_BIT_AIN0  (0x01)
#define STATUS_CONFIG_BIT_AIN1  (0x02)
#define STATUS_CONFIG_BIT_ITEMP (0x04)
#define STATUS_CONFIG_BIT_VODIS (0x08)
#define STATUS_CONFIG_BIT_LDIS  (0x10)
#define STATUS_CONFIG_BIT_SMOD  (0x20)
#define STATUS_CONFIG_BIT_PORF  (0x40)

// Other flags
#define	BQ_CAPACITY_INACCURATE	0xCC
#define	BQ_CAPACITY_ACCURATE	0xAA

typedef struct
{
    	u32  ds2786b_ee_cur_offset_bias_reg;      // one byte         
	u32  ds2786b_ee_capacity_1_reg;           // one byte
	u32  ds2786b_ee_capacity_2_reg;           // one byte
	u32  ds2786b_ee_capacity_3_reg;           // one byte
	u32  ds2786b_ee_capacity_4_reg;           // one byte
	u32  ds2786b_ee_capacity_5_reg;           // one byte
	u32  ds2786b_ee_capacity_6_reg;           // one byte
	u32  ds2786b_ee_capacity_7_reg;           // one byte
	u32  ds2786b_ee_voltg_brk_pt_0_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_1_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_2_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_3_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_4_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_5_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_6_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_7_reg;       // 2 bytes
    	u32  ds2786b_ee_voltg_brk_pt_8_reg;       // 2 bytes
    	u32  ds2786b_ee_init_cap_scaling_reg;     // 1 bytes
    	u32  ds2786b_ee_ocv_cur_thr_reg;          // 1 bytes
    	u32  ds2786b_ee_ocv_dvdt_thr_reg;         // 1 bytes
    	u32  ds2786b_ee_i2c_addr_conf_reg;        // 1 byte
    	u32  ds2786b_ee_learn_thr_reg;            // 1 bytes
    	u32  ds2786b_ee_user_eeprom_reg;          // 1 bytes

} DS2786B_GAS_GAUGE_CFG_BLOCK,*PDS2786B_GAS_GAUGE_CFG_BLOCK;

typedef enum
{
    	DS2786B_CUR_OFFSET_BIAS_VAL     = 0x60000000,   // Address 0x60, one byte          
	DS2786B_CAPACITY_1_VAL          = 0x61000000,   // Address 0x61, one byte
	DS2786B_CAPACITY_2_VAL          = 0x62000000,   // Address 0x62, one byte
	DS2786B_CAPACITY_3_VAL          = 0x63000000,   // Address 0x63, one byte
	DS2786B_CAPACITY_4_VAL          = 0x64010064,   // Address 0x64, one byte
	DS2786B_CAPACITY_5_VAL          = 0x65000000,   // Address 0x65, one byte
	DS2786B_CAPACITY_6_VAL          = 0x66000000,   // Address 0x66, one byte
	DS2786B_CAPACITY_7_VAL          = 0x670100B4,   // Address 0x67, one byte
	DS2786B_VOLTG_BRK_PT_0_VAL      = 0x6802A330,   // Address 0x68, 2 bytes
    	DS2786B_VOLTG_BRK_PT_1_VAL      = 0x6A02B120,   // Address 0x6A, 2 bytes
    	DS2786B_VOLTG_BRK_PT_2_VAL      = 0x6C02BA80,   // Address 0x6C, 2 bytes
    	DS2786B_VOLTG_BRK_PT_3_VAL      = 0x6E02BF50,   // Address 0x6E, 2 bytes
    	DS2786B_VOLTG_BRK_PT_4_VAL      = 0x7002C440,   // Address 0x70, 2 bytes
    	DS2786B_VOLTG_BRK_PT_5_VAL      = 0x7202CDF0,   // Address 0x72, 2 bytes
    	DS2786B_VOLTG_BRK_PT_6_VAL      = 0x7402CEF0,   // Address 0x74, 2 bytes
    	DS2786B_VOLTG_BRK_PT_7_VAL      = 0x7602D100,   // Address 0x76, 2 bytes
    	DS2786B_VOLTG_BRK_PT_8_VAL      = 0x7802D600,   // Address 0x78, 2 bytes
	// Changed based on the email from Paul Connell
    	DS2786B_INIT_CAP_SCALING_VAL    = 0x7A010014,   // Address 0x7A, 1 bytes
    	DS2786B_OCV_CUR_THR_VAL         = 0x7B0100DC,   // Address 0x7B, 1 bytes
    	DS2786B_OCV_DVDT_THR_VAL        = 0x7C000000,   // Address 0x7C, 1 bytes
    	DS2786B_I2C_ADDR_CONF_VAL       = 0x7D000000,   // Address 0x7D, 1 bytes
    	DS2786B_LEARN_THR_VAL           = 0x7E000000,   // Address 0x7E, 1 bytes
    	DS2786B_USER_EEPROM_VAL         = 0x7F010001    // Address 0x7E, 1 bytes
	
} DS2786B_GAS_GAUGE_DEF_VALUES;

/* Crestron UiHAL defines */

//
// Power Management APIs
//
#define AC_LINE_OFFLINE                 0x00
#define AC_LINE_ONLINE                  0x01
#define AC_LINE_BACKUP_POWER            0x02
#define AC_LINE_UNKNOWN                 0xFF

#define BATTERY_FLAG_HIGH               0x01
#define BATTERY_FLAG_LOW                0x02
#define BATTERY_FLAG_CRITICAL           0x04
#define BATTERY_FLAG_CHARGING           0x08
#define BATTERY_FLAG_NO_BATTERY         0x80
#define BATTERY_FLAG_UNKNOWN            0xFF

#define BATTERY_PERCENTAGE_UNKNOWN      0xFF

#define BATTERY_LIFE_UNKNOWN        0xFFFFFFFF

/*
	from (Dennis)SDK 
	C:\Program Files\Windows CE Tools\wce600\MC3SDK\Include\Armv4i\winbase.h

	@struct SYSTEM_POWER_STATUS_EX2 | contains information about the power status
	of the system.

    @field BYTE | ACLineStatus | AC power status. Must be one of
    AC_LINE_OFFLINE, AC_LINE_ONLINE, AC_LINE_BACKUP_POWER, or AC_LINE_UNKNOWN.

    @field BYTE | BatteryFlag | Battery charge status.  Must be one of
	BATTERY_FLAG_HIGH, BATTERY_FLAG_LOW, BATTERY_FLAG_CRITICAL,
	BATTERY_FLAG_CHARGING, BATTERY_FLAG_NO_BATTERY, or BATTERY_FLAG_UNKNOWN

    @field BYTE | BatteryLifePercent | Percentage of full battery charge
    remaining.  Must be in the range 0 to 100, or BATTERY_PERCENTAGE_UNKNOWN.

	@field BYTE | Reserved1 | Must be zero.

    @field DWORD |  BatteryLifeTime | Number of seconds of battery life
    remaining, or BATTERY_LIFE_UNKNOWN if remaining seconds are unknown.

    @field DWORD | BatteryFullLifeTime | Number of seconds of battery life when
    at full charge, or BATTERY_LIFE_UNKNOWN if full lifetime is unknown.

	@field BYTE | Reserved2 | Must be zero.

    @field BYTE | BackupBatteryFlag | Backup battery charge status.  Must be one
    of BATTERY_FLAG_HIGH, BATTERY_FLAG_LOW, BATTERY_FLAG_CRITICAL,
	BATTERY_FLAG_CHARGING, BATTERY_FLAG_NO_BATTERY, or BATTERY_FLAG_UNKNOWN.

    @field BYTE | BackupBatteryLifePercent |  Percentage of full backup battery
    charge remaining.  Must be in the range 0 to 100, or
    BATTERY_PERCENTAGE_UNKNOWN.

	@field BYTE | Reserved3 | Must be zero.

    @field DWORD | BackupBatteryLifeTime | Number of seconds of backup battery
    life remaining, or BATTERY_LIFE_UNKNOWN if remaining seconds are unknown.

    @field DWORD | BackupBatteryFullLifeTime | Number of seconds of backup
    battery life when at full charge, or BATTERY_LIFE_UNKNOWN if full lifetime
    is unknown.

*/

#define BATTERY_CHEMISTRY_ALKALINE     0x01
#define BATTERY_CHEMISTRY_NICD         0x02
#define BATTERY_CHEMISTRY_NIMH         0x03
#define BATTERY_CHEMISTRY_LION         0x04
#define BATTERY_CHEMISTRY_LIPOLY       0x05
#define BATTERY_CHEMISTRY_ZINCAIR      0x06
#define BATTERY_CHEMISTRY_UNKNOWN      0xFF

typedef struct system_power_status_ex2 {
    u8 ACLineStatus;
    u8 BatteryFlag;
    u8 BatteryLifePercent;
    u8 Reserved1;
    u32 BatteryLifeTime;
    u32 BatteryFullLifeTime;
    u8 Reserved2;
    u8 BackupBatteryFlag;
    u8 BackupBatteryLifePercent;
    u8 Reserved3;
    u32 BackupBatteryLifeTime;
    u32 BackupBatteryFullLifeTime;
    // Above here is old struct, below are new fields
    u32 BatteryVoltage; // Reports Reading of battery voltage in millivolts (0..65535 mV)
    u32 BatteryCurrent;	// Reports Instantaneous current drain (mA). 0..32767 for charge, 0 to -32768 for discharge
    u32 BatteryAverageCurrent;// Reports short term avg of dev current drain (mA). 0..32767 for charge, 0 to -32768 for discharge
    u32 BatteryAverageInterval;	// Reports time constant (mS) of integration used in reporting BatteryAverageCurrent
    u32 BatterymAHourConsumed; 	// Reports long-term cumulative average DISCHARGE (mAH). Reset by charging or changing the batteries. 0 to 32767 mAH
   // u32 BatteryTemperature;	// Reports Battery temp in 0.1 degree C (-3276.8 to 3276.7 degrees C)
    u32 BackupBatteryVoltage;	// Reports Reading of backup battery voltage
    u8  BatteryChemistry;     // See Chemistry defines above

    // New fields can be added below, but don't change any existing ones
};

#endif
